<?php
/**
 * Template para listagem de posts do blog
 * 
 * @package Upgram
 * @since 1.27.0
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="upgram-blog-listing-container">
    <div class="upgram-blog-listing-header">
        <h1 class="upgram-blog-listing-title">Blog</h1>
        <p class="upgram-blog-listing-subtitle">Confira nossos últimos artigos</p>
    </div>
    
    <div class="upgram-blog-listing-grid" id="upgram-blog-posts-grid">
        <?php if ($posts->have_posts()) : ?>
            <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                <?php include UPGRAM_PATH . 'templates/blog-post-card.php'; ?>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php else : ?>
            <div class="upgram-blog-listing-empty">
                <p>Nenhum artigo encontrado.</p>
            </div>
        <?php endif; ?>
    </div>
    
    <?php if ($posts->found_posts > 12) : ?>
        <div class="upgram-blog-listing-load-more-container">
            <button id="upgram-load-more-posts" class="upgram-blog-listing-load-more-btn" data-page="2">
                Ver mais artigos
            </button>
            <div class="upgram-blog-listing-loading" style="display: none;">
                <span class="upgram-blog-listing-spinner"></span>
                <span>Carregando...</span>
            </div>
        </div>
    <?php endif; ?>
</div>



